
import java.io.Console;

import atlascard.pc.shared.FOMSBarcode;
import atlascard.pc.shared.Hex;

//    (  )
public class EntryPoint {
	static Console 		_console = null;
	public static void main(String[] args) throws Exception {
		_console = System.console();
		byte[] barcode_data_V1 = Hex.decode("010016E959AF0F3A6C53E684D37771CEEF39DF38711DE4FCD27685DF35419C03000000000000000000000000000000000000000271D3000000EF4A04BDB800F618017DDE3F6B9C4B4592FB28EB75EF1E0D2274BD0F57377284F02469698A8CAC4A912FE74D773AF6FC0C8D71515CB88176EC04A414B179AD00AC548295033972DC82");
		byte[] barcode_data_V2 = Hex.decode("0200000000363D804E9DB3A17503BF84E869B9C3BF39C3A175AA5341C3800000000000000000000000000000000000000000000000000000000000000283EB0000015CEA680D9CDDEF0209E9F91FFEA628328CD157144B634204BAC30F573FF2E1021BDC2A28B2DD50A2761E4CF75FFCDBFBA71EAFC548AD07D38DC82A7D674BD09A");
		try
		{
			FOMSBarcode barcode = FOMSBarcode.parseByteArray(barcode_data_V1);
			printf(" 1");
			printf(String.format("       : %016d", barcode.PolicyNumber));
			printf(String.format("              : %s",   barcode.SureName));
			printf(String.format("                  : %s",   barcode.FirstName));
			printf(String.format("             : %s",   barcode.Patronymic));
			printf(String.format("         : %s",   barcode.BirthDate.toShortDateString()));
			printf(String.format("   : %s",   barcode.ExpireDate.toShortDateString()));
			printf(String.format("                  : %s",   barcode.Sex == 1 ? "":""));
			printf(String.format("          : %s",   Hex.encode(barcode.EDS)));
		}
		catch(Exception exception){
			printf(String.format("Error parsing barcode object: %s", exception.getMessage()));
		}
		try
		{
			FOMSBarcode barcode = FOMSBarcode.parseByteArray(barcode_data_V2);
			printf(" 2");
			printf(String.format("       : %016d", barcode.PolicyNumber));
			printf(String.format("              : %s",   barcode.SureName));
			printf(String.format("                  : %s",   barcode.FirstName));
			printf(String.format("             : %s",   barcode.Patronymic));
			printf(String.format("         : %s",   barcode.BirthDate.toShortDateString()));
			printf(String.format("   : %s",   barcode.ExpireDate.toShortDateString()));
			printf(String.format("                  : %s",   barcode.Sex == 1 ? "":""));
			printf(String.format("          : %s",   Hex.encode(barcode.EDS)));
		}
		catch(Exception exception){
			printf(String.format("Error parsing barcode object: %s", exception.getMessage()));
		}		
	}
	public static void printf(String output){
		if( _console != null )
			_console.printf(String.format("%s\r\n",output));
		else
			System.out.println(output);
	}
}