using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace pcbcode.test.net
{
  class Program
  {
    /// <summary>
    ///   (  ) -     
    /// </summary>
    /// <param name="pcbData"> -</param>
    /// <param name="dwLength"> </param>
    /// <param name="barcode"> () -</param>
    /// <returns></returns>
    [DllImport("pcbcode.dll", EntryPoint = "DecomposeBarcode", CharSet = CharSet.Ansi, SetLastError = true)]
    private static extern uint DecomposeBarcode(
     [MarshalAs(UnmanagedType.LPArray), In]
     byte[] pcbData,
     [MarshalAs(UnmanagedType.I4), In]
     int dwLength,
     [MarshalAs(UnmanagedType.Struct), In, Out]
     ref BARCODE_T1 barcode);

    static void Main(string[] args)
    {
      // -   
      byte[] bar_code_data_V1 = new byte[]
      {
	      0x01, 0x00, 0x16, 0xE9, 0x59, 0xAF, 0x0F, 0x3A, 
	      0x6C, 0x53, 0xE6, 0x84, 0xD3, 0x77, 0x71, 0xCE, 
	      0xEF, 0x39, 0xDF, 0x38, 0x71, 0x1D, 0xE4, 0xFC, 
	      0xD2, 0x76, 0x85, 0xDF, 0x35, 0x41, 0x9C, 0x03, 
	      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	      0x00, 0x00, 0x00, 0x02, 0x71, 0xD3, 0x00, 0x00, 
	      0x00, 0xEF, 0x4A, 0x04, 0xBD, 0xB8, 0x00, 0xF6, 
	      0x18, 0x01, 0x7D, 0xDE, 0x3F, 0x6B, 0x9C, 0x4B, 
	      0x45, 0x92, 0xFB, 0x28, 0xEB, 0x75, 0xEF, 0x1E, 
	      0x0D, 0x22, 0x74, 0xBD, 0x0F, 0x57, 0x37, 0x72, 
	      0x84, 0xF0, 0x24, 0x69, 0x69, 0x8A, 0x8C, 0xAC, 
	      0x4A, 0x91, 0x2F, 0xE7, 0x4D, 0x77, 0x3A, 0xF6, 
	      0xFC, 0x0C, 0x8D, 0x71, 0x51, 0x5C, 0xB8, 0x81, 
	      0x76, 0xEC, 0x04, 0xA4, 0x14, 0xB1, 0x79, 0xAD, 
	      0x00, 0xAC, 0x54, 0x82, 0x95, 0x03, 0x39, 0x72, 
	      0xDC, 0x82 
      };
      byte[] bar_code_data_V2 = new byte[]
      {
		    0x02, 0x00, 0x00, 0x00, 0x00, 0x36, 0x3D, 0x80, 
		    0x4E, 0x9D, 0xB3, 0xA1, 0x75, 0x03, 0xBF, 0x84, 
		    0xE8, 0x69, 0xB9, 0xC3, 0xBF, 0x39, 0xC3, 0xA1, 
		    0x75, 0xAA, 0x53, 0x41, 0xC3, 0x80, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00, 0x02, 0x83, 0xEB, 0x00, 
		    0x00, 0x01, 0x5C, 0xEA, 0x68, 0x0D, 0x9C, 0xDD, 
		    0xEF, 0x02, 0x09, 0xE9, 0xF9, 0x1F, 0xFE, 0xA6, 
		    0x28, 0x32, 0x8C, 0xD1, 0x57, 0x14, 0x4B, 0x63, 
		    0x42, 0x04, 0xBA, 0xC3, 0x0F, 0x57, 0x3F, 0xF2, 
		    0xE1, 0x02, 0x1B, 0xDC, 0x2A, 0x28, 0xB2, 0xDD, 
		    0x50, 0xA2, 0x76, 0x1E, 0x4C, 0xF7, 0x5F, 0xFC, 
		    0xDB, 0xFB, 0xA7, 0x1E, 0xAF, 0xC5, 0x48, 0xAD, 
		    0x07, 0xD3, 0x8D, 0xC8, 0x2A, 0x7D, 0x67, 0x4B, 
		    0xD0, 0x9A
      };
      // -
      BARCODE_T1 barcode_V1 = new BARCODE_T1();
      //  (  ) -
      uint dwError = DecomposeBarcode(bar_code_data_V1, bar_code_data_V1.Length, ref barcode_V1);
      if (dwError != 0)
      {
        //  
        Console.WriteLine(PCBCodeAPIException.GetLastWin32Error().Message);
      }
      else
        printobj(barcode_V1);
      BARCODE_T1 barcode_V2 = new BARCODE_T1();
      //  (  ) -
      dwError = DecomposeBarcode(bar_code_data_V2, bar_code_data_V1.Length, ref barcode_V2);
      if (dwError != 0)
      {
        //  
        Console.WriteLine(PCBCodeAPIException.GetLastWin32Error().Message);
      }
      else
        printobj(barcode_V2);
    }

    static void printobj(BARCODE_T1 barcode)
    {
      printf(" -:         {0}", barcode.BarcodeType);
      printf("  :       {0:D16}", barcode.PolicyNumber);
      printf(":                {0}", barcode.LastName);
      printf(":                    {0}", barcode.FirstName);
      printf(":               {0}", barcode.Patronymic);
      printf(" :          {0:dd.MM.yyyy}", getDate(barcode.BirthDate));
      printf("      {0:dd.MM.yyyy}", getDate(barcode.ExpireDate));
      printf("                     {0}", barcode.Sex == 1 ? "" : "");
    }

    static string getDate(SYSTEMTIME value)
    {
      return string.Format("{0:D2}.{1:D2}.{2:D4}", value.wDay, value.wMonth, value.wYear);
    }

    static void printf(string format, params object[] args)
    {
      Console.WriteLine(format, args);
    }
  }

  /// <summary>
  ///  -
  /// </summary>
  [StructLayout(LayoutKind.Sequential, Pack = 1, Size = 203, CharSet = CharSet.Ansi)]
  public struct BARCODE_T1
  {
    [MarshalAs(UnmanagedType.U1)]
    public byte BarcodeType;
    [MarshalAs(UnmanagedType.U8)]
    public ulong PolicyNumber;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
    public string FirstName;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
    public string LastName;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
    public string Patronymic;
    [MarshalAs(UnmanagedType.U1)]
    public byte Sex;
    [MarshalAs(UnmanagedType.Struct)]
    public SYSTEMTIME BirthDate;
    [MarshalAs(UnmanagedType.Struct)]
    public SYSTEMTIME ExpireDate;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 17)]
    public string PolicyNumberString;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 65)]
    public byte[] EDS;
  }

  [StructLayout(LayoutKind.Explicit)]
  public struct SYSTEMTIME
  {
    [MarshalAs(UnmanagedType.U2), FieldOffset(0)]
    public ushort wYear;
    [MarshalAs(UnmanagedType.U2), FieldOffset(2)]
    public ushort wMonth;
    [MarshalAs(UnmanagedType.U2), FieldOffset(4)]
    public ushort wDayOfWeek;
    [MarshalAs(UnmanagedType.U2), FieldOffset(6)]
    public ushort wDay;
    [MarshalAs(UnmanagedType.U2), FieldOffset(8)]
    public ushort wHour;
    [MarshalAs(UnmanagedType.U2), FieldOffset(10)]
    public ushort wMinute;
    [MarshalAs(UnmanagedType.U2), FieldOffset(12)]
    public ushort wSecond;
    [MarshalAs(UnmanagedType.U2), FieldOffset(14)]
    public ushort wMilliseconds;
  }

  /// <summary>  <see cref="CryptoAPI"/></summary>
  public class PCBCodeAPIException : Exception
  {
    public PCBCodeAPIException()
      : base()
    {
    }
    public PCBCodeAPIException(string message)
      : base(message)
    {
    }
    public PCBCodeAPIException(string message, Exception innerException)
      : base(message, innerException)
    {
    }

    /// <summary>       WIN32</summary>
    /// <returns><see cref="PCBCodeAPIException"/> </returns>
    public static PCBCodeAPIException GetLastWin32Error()
    {
      return new PCBCodeAPIException(GetLastWin32ErrorString((uint)Marshal.GetLastWin32Error()));
    }

    /// <summary>    WIN32</summary>
    /// <returns> </returns>
    public static String GetLastWin32ErrorString(uint errorCode)
    {
      String msg = "";
      try
      {
        IntPtr pt = IntPtr.Zero;
        UInt32 f_ret = Kernel32.FormatMessage(
          (uint)FormatMessageFlags.FORMAT_MESSAGE_ALLOCATE_BUFFER | (uint)FormatMessageFlags.FORMAT_MESSAGE_FROM_SYSTEM | (uint)FormatMessageFlags.FORMAT_MESSAGE_FROM_HMODULE | (uint)FormatMessageFlags.FORMAT_MESSAGE_IGNORE_INSERTS,
          Kernel32.GetModuleHandle("pcbcode.dll"),
          errorCode,
          0x419, //RUSSIAN, 0-Default (English)
          out pt,
          0,
          IntPtr.Zero
          );
        if (f_ret == 0)
        {
          if (pt.ToInt32() != 0)
          {
            IntPtr ret = Kernel32.LocalFree(pt);
            if (ret.ToInt32() != 0)
              throw new System.ComponentModel.Win32Exception(
                System.Runtime.InteropServices.Marshal.GetLastWin32Error(), "Could not free System allocated buffer.");
          }
          throw new System.ComponentModel.Win32Exception(
            System.Runtime.InteropServices.Marshal.GetLastWin32Error(), "Could not format System error message.");
        }
        msg = System.Runtime.InteropServices.Marshal.PtrToStringUni(pt);

        IntPtr free_ret = Kernel32.LocalFree(pt);

        if (free_ret.ToInt32() != 0)
          throw new System.ComponentModel.Win32Exception(
            System.Runtime.InteropServices.Marshal.GetLastWin32Error(), "Could not free System allocated buffer.");
      }
      catch (Exception e)
      {
        throw e;
      }
      return msg.Replace("\r", "").Replace("\n", "");
    }
  }

  public static class Kernel32
  {
    /// <summary>
    /// The GetModuleHandle function retrieves a module handle for the specified module if the file has been mapped into the address space of the calling process
    /// </summary>
    /// <returns>If the function succeeds, the return value is a handle to the specified module</returns>
    [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
    public static extern IntPtr GetModuleHandle(string lpModuleName);

    /// <summary>Frees the specified local memory object and invalidates its handle.</summary>
    /// <param name="hMem">A handle to the local memory object. This handle is returned by either the LocalAlloc or LocalReAlloc function. It is not safe to free memory allocated with GlobalAlloc.</param>
    /// <returns>Return Value
    /// <para>If the function succeeds, the return value is NULL.</para>
    /// <para>If the function fails, the return value is equal to a handle to the local memory object. To get extended error information, call GetLastError.</para>
    /// </returns>
    [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
    public static extern IntPtr LocalFree(IntPtr hMem);

    /// <summary>
    /// The FormatMessage function formats a message string. The function requires a message 
    /// definition as input. The message definition can come from a buffer passed into the function. 
    /// It can come from a message table resource in an already-loaded module. Or the caller can ask 
    /// the function to search the system's message table resource(s) for the message definition. 
    /// The function finds the message definition in a message table resource based on a message 
    /// identifier and a language identifier. The function copies the formatted message text to an 
    /// output buffer, processing any embedded insert sequences if requested.
    /// </summary>
    /// <param name="dwFlags">[in] Formatting options, and how to interpret the lpSource parameter. 
    /// The low-order byte of dwFlags specifies how the function handles line breaks in the output buffer. 
    /// The low-order byte can also specify the maximum width of a formatted output line. </param>
    /// <param name="lpSource">[in] Location of the message definition. The type of this 
    /// parameter depends upon the settings in the dwFlags parameter.</param>
    /// <param name="dwMessageId">[in] Message identifier for the requested message.</param>
    /// <param name="dwLanguageId">[in] Language identifier for the requested message.</param>
    /// <param name="lpBuffer">[out] Pointer to a buffer that receives null-terminated string that specifies 
    /// the formatted message. If dwFlags includes FORMAT_MESSAGE_ALLOCATE_BUFFER, the function 
    /// allocates a buffer using the LocalAlloc function, and places the pointer to the buffer 
    /// at the address specified in lpBuffer.</param>
    /// <param name="nSize">[in] If the FORMAT_MESSAGE_ALLOCATE_BUFFER flag is not set, this parameter specifies 
    /// the maximum number of TCHARs that can be stored in the output buffer. 
    /// If FORMAT_MESSAGE_ALLOCATE_BUFFER is set, this parameter specifies the minimum number of 
    /// TCHARs to allocate for an output buffer.</param>
    /// <param name="Arguments">[in] Pointer to an array of values that are used as insert values in the 
    /// formatted message. A %1 in the format string indicates the first value in the Arguments array; 
    /// a %2 indicates the second argument; and so on.
    /// The interpretation of each value depends on the formatting information 
    /// associated with the insert in the message definition. The default is to treat each value as a 
    /// pointer to a null-terminated string. By default, the Arguments parameter is of type va_list*, 
    /// which is a language- and implementation-specific data type for describing a variable number of 
    /// arguments. If you do not have a pointer of type va_list*, then specify the 
    /// FORMAT_MESSAGE_ARGUMENT_ARRAY flag and pass a pointer to an array of values; 
    /// those values are input to the message formatted as the insert values. 
    /// Each insert must have a corresponding element in the array.</param>
    /// <returns><para>If the function succeeds, the return value is the number of TCHARs stored in the output buffer, excluding the terminating null character.</para>
    /// <para>the function fails, the return value is zero. To get extended error information, call GetLastError.</para>
    ///</returns>
    [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
    public static extern UInt32 FormatMessage(
      UInt32 dwFlags,
      IntPtr lpSource,
      UInt32 dwMessageId,
      UInt32 dwLanguageId,
      out IntPtr lpBuffer,
      UInt32 nSize,
      IntPtr Arguments
      );
  }

  /// <summary>Specifies aspects of the formatting process and how to interpret the lpSource parameter.</summary>
  [Flags()]
  public enum FormatMessageFlags : uint
  {
    /// <summary>Specifies that the lpBuffer parameter is a pointer to a PVOID pointer, and that the nSize parameter 
    /// specifies the minimum number of bytes (ANSI version) or characters (Unicode version) to 
    /// allocate for an output message buffer. The function allocates a buffer large enough to hold 
    /// the formatted message, and places a pointer to the allocated buffer at the address specified by lpBuffer. 
    /// The caller should use the LocalFree function to free the buffer when it is no longer needed.</summary>
    FORMAT_MESSAGE_ALLOCATE_BUFFER = 0x00000100,
    /// <summary>Specifies that insert sequences in the message definition are to be ignored and passed through 
    /// to the output buffer unchanged. This flag is useful for fetching a message for later formatting. 
    /// If this flag is set, the Arguments parameter is ignored.</summary>
    FORMAT_MESSAGE_IGNORE_INSERTS = 0x00000200,
    /// <summary>Specifies that lpSource is a pointer to a null-terminated message definition. 
    /// The message definition may contain insert sequences, just as the message text in a message table resource may. 
    /// Cannot be used with FORMAT_MESSAGE_FROM_HMODULE or FORMAT_MESSAGE_FROM_SYSTEM.</summary>
    FORMAT_MESSAGE_FROM_STRING = 0x00000400,
    /// <summary>Specifies that lpSource is a module handle containing the message-table resources to search. 
    /// If this lpSource handle is NULL, the current process's application image file will be searched. 
    /// Cannot be used with FORMAT_MESSAGE_FROM_STRING.</summary>
    FORMAT_MESSAGE_FROM_HMODULE = 0x00000800,
    /// <summary>Specifies that the function should search the system message-table resources for the requested message. 
    /// If this flag is specified with FORMAT_MESSAGE_FROM_HMODULE, the function searches the system message table 
    /// if the message is not found in the module specified by lpSource. Cannot be used with FORMAT_MESSAGE_FROM_STRING. 
    ///If this flag is specified, an application can pass the result of the GetLastError function 
    ///to retrieve the message text for a system-defined error.</summary>
    FORMAT_MESSAGE_FROM_SYSTEM = 0x00001000,
    /// <summary>Specifies that the Arguments parameter is not a va_list structure, but instead is just a pointer to 
    /// an array of 32-bit values that represent the arguments.</summary>
    FORMAT_MESSAGE_ARGUMENT_ARRAY = 0x00002000,
    /// <summary>The nonzero value is the maximum number of characters in an output line. 
    /// The function ignores regular line breaks in the message definition text. 
    /// The function never splits a string delimited by white space across a line break. 
    /// The function stores hard-coded line breaks in the message definition text into the output buffer. 
    /// Hard-coded line breaks are coded with the %n escape sequence.</summary>
    FORMAT_MESSAGE_MAX_WIDTH_MASK = 0x000000FF
  }
}